<?php
function adapters($server)
{
   $adapters = [];
   if (isset($server->eth0) && $server->eth0 == 1) {
      $adapters[0]["index"] = 0;
      $adapters[0]["name"] = "";
      $adapters[0]["enabled"] = $server->eth0;
      $adapters[0]["server_ip"] = isset($server->ip) ? $server->ip : "";
      $adapters[0]["server_mask"] = isset($server->mask) ? $server->mask : "";
      $adapters[0]["port"] = isset($server->port) ? $server->port : 0;
      $adapters[0]["mac"] = isset($server->mac0) ? $server->mac0 : "no data";
      $adapters[0]["speed"] = isset($server->eth0spid) ? $server->eth0spid : 0;
      $adapters[0]["out_speed"] = isset($server->eth0outspeed) ? $server->eth0outspeed : 0;
      if (isset($server->eth1inspeed)) {
         if (($server->eth1 == 0 || !isset($server->ip2)) && ($server->eth2 == 0 || !isset($server->ip3))) {
            $adapters[0]["in_speed"] = $server->eth1inspeed;
         }
      }
      $adapters[0]["gateway"] = isset($server->gateway) ? $server->gateway : "";
      $adapters[0]["dhcp"] = isset($server->dhcp) ? $server->dhcp : 0;

      if (isset($server->httpiviport)) {
         $adapters[0]["httpiviport"] = (int) $server->httpiviport === 0 ? "" : $server->httpiviport;
      } else {
         $adapters[0]["httpiviport"] = "";
      }
      $adapters[0]["httpiviportauth"] = isset($server->httpiviportauth) ? (int) $server->httpiviportauth : 0;
      try {
         $adapters[0]["iviusername"] = isset($server->iviusername)
            ? mb_convert_encoding($server->iviusername, "windows-1251", "utf-8")
            : "";
      } catch (Exception $e) {
         $adapters[0]["iviusername"] = "";
      }
   }
   if (isset($server->eth1) && $server->eth1 == 1) {
      $adapters[1]["index"] = 1;
      $adapters[1]["name"] = "(Камеры)";
      $adapters[1]["enabled"] = $server->eth1;
      $adapters[1]["server_ip"] = isset($server->ip2) ? $server->ip2 : "";
      $adapters[1]["server_mask"] = isset($server->mask2) ? $server->mask2 : "";
      $adapters[1]["port"] = false;
      $adapters[1]["mac"] = isset($server->mac1) ? $server->mac1 : "no data";
      $adapters[1]["speed"] = isset($server->eth1spid) ? $server->eth1spid : 0;
      $adapters[1]["in_speed"] =
         isset($server->eth1inspeed) && isset($server->ip2) ? $server->eth1inspeed : 0;
      $adapters[1]["gateway"] = isset($server->gateway2) ? $server->gateway2 : "";
      $adapters[1]["dhcp"] = isset($server->dhcp2) ? $server->dhcp2 : 0;
   } elseif (isset($server->eth3) && $server->eth3 == 1) {
      $adapters[1]["index"] = 1;
      $adapters[1]["name"] = "(Камеры)";
      $adapters[1]["disabled"] = true;
   }
   if (isset($server->eth2) && $server->eth2 == 1) {
      $adapters[2]["index"] = 2;
      $adapters[2]["name"] = "(Камеры)";
      $adapters[2]["enabled"] = $server->eth2;
      $adapters[2]["server_ip"] = isset($server->ip3) ? $server->ip3 : "";
      $adapters[2]["server_mask"] = isset($server->mask3) ? $server->mask3 : "";
      $adapters[2]["port"] = false;
      $adapters[2]["mac"] = isset($server->mac2) ? $server->mac2 : "no data";
      $adapters[2]["speed"] = isset($server->eth2spid) ? $server->eth2spid : 0;
      $adapters[2]["in_speed"] = isset($server->eth2inspeed) ? $server->eth2inspeed : 0;
      $adapters[2]["gateway"] = isset($server->gateway3) ? $server->gateway3 : "";
      $adapters[2]["dhcp"] = isset($server->dhcp3) ? $server->dhcp3 : 0;
   } elseif (isset($server->eth3) && $server->eth3 == 1) {
      $adapters[2]["index"] = 2;
      $adapters[2]["name"] = "(Камеры)";
      $adapters[2]["disabled"] = true;
   }
   if (isset($server->eth3) && $server->eth3 == 1) {
      $adapters[3]["index"] = 3;
      $adapters[3]["name"] = "";
      $adapters[3]["enabled"] = $server->eth3;
      $adapters[3]["server_ip"] = isset($server->ip1) ? $server->ip1 : "";
      $adapters[3]["server_mask"] = isset($server->mask1) ? $server->mask1 : "";
      $adapters[3]["port"] = isset($server->port) ? $server->port : 0;
      $adapters[3]["mac"] = isset($server->mac3) ? $server->mac3 : "no data";
      $adapters[3]["speed"] = isset($server->eth3spid) ? $server->eth3spid : 0;
      $adapters[3]["out_speed"] = isset($server->eth3outspeed) ? $server->eth3outspeed : 0;
      $adapters[3]["gateway"] = isset($server->gateway1) ? $server->gateway1 : "";
      $adapters[3]["dhcp"] = isset($server->dhcp1) ? $server->dhcp1 : 0;

      if (isset($server->httpiviport1)) {
         $adapters[3]["httpiviport"] = (int) $server->httpiviport1 === 0 ? "" : $server->httpiviport1;
      } else {
         $adapters[3]["httpiviport"] = "";
      }
      $adapters[3]["httpiviportauth"] = isset($server->httpiviportauth1)
         ? (int) $server->httpiviportauth1
         : 0;
      try {
         $adapters[3]["iviusername"] = isset($server->iviusername)
            ? mb_convert_encoding($server->iviusername, "windows-1251", "utf-8")
            : "";
      } catch (Exception $e) {
         $adapters[3]["iviusername"] = "";
      }
   }
   return $adapters;
}
function getAdapters()
{
   $sock = Login();
   $server = ParamGet($sock, "server");
   $adapters = adapters($server->server);
   socket_close($sock);
   return $adapters;
}
